#include <iostream>
#include <vector>

using namespace std;

struct Soba {
  int id;
  bool platforma;
  vector<int> susedi;
};

struct Zec {
  int id;
  int snaga;
  int broj_skokova;
};

int main() {
  int n, m;
  cin >> n >> m;

  vector<Soba> sobe(n);
  for (int i = 0; i < n; i++) {
    int id;
    cin >> id;
    sobe[i].id = id;
    sobe[i].platforma = cin >> id;
  }

  for (int i = 0; i < m; i++) {
    int u, v;
    cin >> u >> v;
    sobe[u].susedi.push_back(v);
    sobe[v].susedi.push_back(u);
  }

  vector<Zec> zecevi(n);
  for (int i = 0; i < n; i++) {
    zecevi[i].id = i + 1;
    zecevi[i].snaga = i + 1;
    zecevi[i].broj_skokova = 0;
  }

  for (int i = 0; i < n; i++) {
    // Promeni stanje sobe pre nego što zver krene
    sobe[i].platforma = cin >> i;

    // Probaj da pronadeš put za zver
    zecevi[i].broj_skokova = pronadi_put(i, sobe);
  }

  // Ispiši rezultat
  for (int i = 0; i < n; i++) {
    cout << zecevi[i].broj_skokova << " ";
  }
  cout << endl;

  return 0;
}

int pronadi_put(int zver, vector<Soba>& sobe) {
  // Inicijaliziraj stanje
  vector<bool> posecene(n, false);
  queue<int> red;

  // Dodaj zver u red
  red.push(zver);

  // Dok postoji red
  while (!red.empty()) {
    // Izvadimo zver iz reda
    int trenutna = red.front();
    red.pop();

    // Ako je zver stigla do izlaza
    if (trenutna == 0) {
      // Vrati broj skokova
      return posecene[trenutna] ? -1 : zecevi[zver].broj_skokova;
    }

    // Ako zver nije posecena
    if (!posecene[trenutna]) {
      // Oznaci je kao posecenu
      posecene[trenutna] = true;

      // Za svaku susednu sobu
      for (int i = 0; i < sobe[trenutna].susedi.size(); i++) {
        // Ako je zver dovoljno jaka da stigne do susedne sobe
        if (zecevi[zver].snaga >= sobe[trenutna].susedi[i]) {
          // Dodaj susednu sobu u red
          red.push(sobe[trenutna].susedi[i]);

          // Povecaj broj skokova
          zecevi[zver].broj_skokova++;
        }
      }
    }
  }

  // Ako red nije prazan, onda zver ne može da izade
  return -1;
}